// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Rich edit ole support.
//.......................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <richedit.h>
#include "Tscmsg.h"
#include <Richole.h>
#include <ole2.h>
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD			dwStringSafeFlag;
extern	BOOL			bNoCallBack;
extern	HWND			hMainWindow;
extern	LPCTSTR			lpszAppName;
extern	LPCTSTR			lpIconPointer;
extern	HWND			hCurrentRtfWnd;
extern	DWORD			dwPageCount;
extern	LPBYTE			lpOutBuffer;
extern	EDITSTREAM		eStreamRecv;
extern	TCHAR			szRTFHeader[];
extern	TCHAR			szRTFImagePost[];
extern	LPTSTR			lpFontFamily[];

IRichEditOleCallbackVtbl		MyIRichEditOleCallbackVtbl;
LPRICHEDITOLECALLBACK			lpRichEditOleCallback;

ULONG		uAddRef;
HWND		hMyOleDlg;
int			iMyOleControlID;
BOOL		bReadRtf;

// Image file extensions.
//.......................
TCHAR		szBmp[] = ".bmp";
TCHAR		szJpg[] = ".jpg";
TCHAR		szGif[] = ".gif";
TCHAR		szPng[] = ".png";

LPCTSTR		lpImageFiles[] = {(LPCTSTR)&szBmp,(LPCTSTR)&szJpg,(LPCTSTR)&szGif,
							  (LPCTSTR)&szPng};

BOOL		bIHaveABitmap;

#define		MAX_IMAGEFILES	4

// QueryInterface items.
//......................
STDMETHODIMP MyQueryInterface(LPRICHEDITOLECALLBACK lpRichEditOleCallback, REFIID iid, 
							  LPVOID FAR* ppvObject)
{
	return(S_OK);
}

STDMETHODIMP_(ULONG) MyAddRef(LPRICHEDITOLECALLBACK lpRichEditOleCallback)
{
	uAddRef++;

	return(uAddRef);
}

STDMETHODIMP_(ULONG) MyRelease(LPRICHEDITOLECALLBACK lpRichEditOleCallback)
{
	uAddRef--;

	return(uAddRef);
}

STDMETHODIMP MyContextSensitiveHelp(LPRICHEDITOLECALLBACK lpRichEditOleCallback, 
									BOOL fEnterMode)
{
	return(S_OK);
}

STDMETHODIMP MyDeleteObject(LPRICHEDITOLECALLBACK lpRichEditOleCallback, LPOLEOBJECT lpoleobj)
{
	return(S_OK);
}

STDMETHODIMP MyGetClipboardData(LPRICHEDITOLECALLBACK lpRichEditOleCallback, 
								CHARRANGE FAR *lpchrg, DWORD reco,
								LPDATAOBJECT FAR *lplpdataobj)
{
	return(E_NOTIMPL);
}

STDMETHODIMP MyGetContextMenu(LPRICHEDITOLECALLBACK lpRichEditOleCallback, WORD seltype, 
							  LPOLEOBJECT lpoleobj,
							  CHARRANGE FAR *lpchrg, HMENU FAR *lphmenu)
{
	if (bReadRtf)
	{
		ReadContextMenu(hMyOleDlg,GetDlgItem(hMyOleDlg,iMyOleControlID),GetMessagePos());
	}
	else
	{
		RtfContextMenu(hMyOleDlg,GetDlgItem(hMyOleDlg,iMyOleControlID),GetMessagePos(),iMyOleControlID);
	}
	return(E_INVALIDARG);
}

STDMETHODIMP MyGetDragDropEffect(LPRICHEDITOLECALLBACK lpRichEditOleCallback, BOOL fDrag, 
								 DWORD grfKeyState, LPDWORD pdwEffect)
{
	return(S_OK);
}

STDMETHODIMP MyGetInPlaceContext(LPRICHEDITOLECALLBACK lpRichEditOleCallback, 
								 LPOLEINPLACEFRAME FAR * lplpFrame,
								 LPOLEINPLACEUIWINDOW FAR * lplpDoc,
								 LPOLEINPLACEFRAMEINFO lpFrameInfo)
{
	return(E_INVALIDARG);
}

STDMETHODIMP MyGetNewStorage(LPRICHEDITOLECALLBACK lpRichEditOleCallback, 
							 LPSTORAGE FAR *lplpstg)
{
	ILockBytes		*lpLb = NULL;
	SCODE			sc;

	sc = CreateILockBytesOnHGlobal(NULL,TRUE,&lpLb);
	if (sc == S_OK)
	{
		sc = StgCreateDocfileOnILockBytes(lpLb,
										  STGM_SHARE_EXCLUSIVE | STGM_CREATE | STGM_READWRITE,
										  0,lplpstg);
		if (sc != S_OK)
		{
			lpLb->lpVtbl->Release(lpLb);
		}
	}
	return(sc);
}

STDMETHODIMP MyQueryAcceptData(LPRICHEDITOLECALLBACK lpRichEditOleCallback, 
							   LPDATAOBJECT lpdataobj,
							   CLIPFORMAT FAR * lpcfFormat, DWORD reco,
							   BOOL fReally, HGLOBAL hMetaPict)
{
	// Drag and drop to be implemented in the future, maybe.
	//......................................................
	if (reco == RECO_DROP)
	{
		return(S_FALSE);
	}
	else
	{
		return(S_OK);
	}
}

STDMETHODIMP MyQueryInsertObject(LPRICHEDITOLECALLBACK lpRichEditOleCallback, 
								 LPCLSID lpclsid, LPSTORAGE lpstg, LONG cp)
{
	return(S_OK);
}

STDMETHODIMP MyShowContainerUI(LPRICHEDITOLECALLBACK lpRichEditOleCallback, BOOL fShow)
{
	return(S_OK);
}

// Initiate the IRichEditOleCallbackVtbl interface.
//.................................................
VOID InitiateRichEditOleCallbackInterface()
{
	MyIRichEditOleCallbackVtbl.QueryInterface = MyQueryInterface;
	MyIRichEditOleCallbackVtbl.AddRef = MyAddRef;
	MyIRichEditOleCallbackVtbl.Release = MyRelease;
	MyIRichEditOleCallbackVtbl.ContextSensitiveHelp = MyContextSensitiveHelp;
	MyIRichEditOleCallbackVtbl.DeleteObject = MyDeleteObject;
	MyIRichEditOleCallbackVtbl.GetClipboardData = MyGetClipboardData;
	MyIRichEditOleCallbackVtbl.GetContextMenu = MyGetContextMenu;
	MyIRichEditOleCallbackVtbl.GetDragDropEffect = MyGetDragDropEffect;
	MyIRichEditOleCallbackVtbl.GetInPlaceContext = MyGetInPlaceContext;
	MyIRichEditOleCallbackVtbl.GetNewStorage = MyGetNewStorage;
	MyIRichEditOleCallbackVtbl.QueryAcceptData = MyQueryAcceptData;
	MyIRichEditOleCallbackVtbl.QueryInsertObject = MyQueryInsertObject;
	MyIRichEditOleCallbackVtbl.ShowContainerUI = MyShowContainerUI;

	lpRichEditOleCallback = (LPRICHEDITOLECALLBACK)&MyIRichEditOleCallbackVtbl;
}

// Setup the rich exit ole callback function.
//...........................................
VOID SetupOleCallback(HWND hDlg, int iControlID)
{
	LRESULT		lResult;

	hMyOleDlg = hDlg;
	iMyOleControlID = iControlID;

	if (iControlID == IDC_RNOTE)
	{
		bReadRtf = TRUE;
	}
	else
	{
		bReadRtf = FALSE;
	}
	bNoCallBack = FALSE;

	lResult = SendMessage(GetDlgItem(hDlg,iControlID),EM_SETOLECALLBACK,0,
					     (LPARAM)&lpRichEditOleCallback);
	if (!lResult)
	{
		bNoCallBack = TRUE;
	}
}

// Insert a picture into a rich text edit control.
//................................................
VOID InsertPicture()
{
	OPENFILENAME		ofn;
	TCHAR				szMyPicture[MAX_PATH];
	OLECHAR				pszMyPicture[MAX_PATH];
	LPTSTR				lpExt;
	int					iResult;
	int					i;
	BOOL				bResult;
	BOOL				bHaveMatch = FALSE;
	BOOL				bHaveOle = FALSE;
	LPRICHEDITOLE		m_pRichEditOle = NULL;
	LPOLEOBJECT			m_lpObject = NULL;
	LPSTORAGE			m_lpStorage = NULL;
	LPOLECLIENTSITE		m_lpClientSite = NULL;
	LRESULT				lResult;
	LPLOCKBYTES			lpLockBytes = NULL;
	CLSID				clsid = CLSID_NULL;
	OLERENDER			render = OLERENDER_DRAW;
	CLIPFORMAT			cfFormat = 0;
	LPFORMATETC			lpFormatEtc = NULL;
	SCODE				sc;
	FORMATETC			formatEtc;
	LPUNKNOWN			lpUnk;
	REOBJECT			reobject;
	SIZEL				sizel;

	lResult = OleInitialize(NULL);
	bIHaveABitmap = FALSE;

	// Get the rich edit ole interface.
	//.................................
	lResult = SendMessage(hCurrentRtfWnd,EM_GETOLEINTERFACE,0,(LPARAM)&m_pRichEditOle);
	if (!lResult)
	{
		goto SelectEnd;
	}
	bHaveOle = TRUE;

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	ofn.lpstrFile = szMyPicture;
	ofn.nMaxFile = sizeof(szMyPicture);
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("Image Files [.bmp;.jpg;.gif;.png]\0*.bmp;*.jpg;*.gif;*.png\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Select an Image File to Insert");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
					 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_HIDEREADONLY |
					 OFN_SHOWHELP);
	ofn.lpstrDefExt = NULL;
	ofn.lpfnHook = MyOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	while(TRUE)
	{
		ZeroMemory(&szMyPicture,sizeof(szMyPicture));

		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto SelectEnd;
		}
		EmptyTheMessageQue();

		SaveDirName((LPBYTE)&szMyPicture,SAVE_SOURCE,TRUE);

		// Make sure we have a valid image file.
		//......................................
		lpExt = PathFindExtension((LPCTSTR)&szMyPicture);

		for (i = 0; i < MAX_IMAGEFILES; i++)
		{
			iResult = CompareString(LOCALE_USER_DEFAULT,NORM_IGNORECASE,
								   (LPCTSTR)lpExt,-1,(LPCTSTR)lpImageFiles[i],-1);
			if (iResult == CSTR_EQUAL)
			{
				bHaveMatch = TRUE;
				if (i == 0)
				{
					bIHaveABitmap = TRUE;
				}
				break;
			}
		}
		if (bHaveMatch)
		{
			break;
		}
		// Display error message box.
		//...........................
		MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NOTIMAGEFILE,MB_ICONINFORMATION | MB_OK,
					   MB_ICONINFORMATION,0);
	}
	EmptyTheMessageQue();

	// If we have a bitmap file load it as a metafile.
	//................................................
	if (bIHaveABitmap)
	{
		bResult = LoadMyBitmap((LPCTSTR)&szMyPicture);
		if (bResult)
		{
			NotifyMe();
		}
		goto SelectEnd;
	}
	// Let's go to work on the ole.
	//.............................
	sc = CreateILockBytesOnHGlobal(NULL,TRUE,&lpLockBytes);
	if (sc != S_OK)
	{
		goto SelectEnd;
	}
	if (lpLockBytes == NULL)
	{
		goto SelectEnd;
	}
	sc = StgCreateDocfileOnILockBytes(lpLockBytes,
									  STGM_SHARE_EXCLUSIVE | STGM_CREATE | STGM_READWRITE,
									  0,&m_lpStorage);
	if (sc != S_OK)
	{
		lpLockBytes->lpVtbl->Release(lpLockBytes);
		lpLockBytes = NULL;
		goto SelectEnd;
	}
	if (m_lpStorage == NULL)
	{
		goto SelectEnd;
	}
	// Fill in the FormatEtc structure.
	//.................................
	lpFormatEtc = &formatEtc;
	lpFormatEtc->cfFormat = cfFormat;
	lpFormatEtc->ptd = NULL;
	lpFormatEtc->dwAspect = DVASPECT_CONTENT;
	lpFormatEtc->lindex = -1;
	lpFormatEtc->tymed = TYMED_NULL;

	// Attempt to create the object.
	//..............................
	m_pRichEditOle->lpVtbl->GetClientSite(m_pRichEditOle,&m_lpClientSite);

	if (m_lpClientSite == NULL)
	{
		goto SelectEnd;
	}
	MultiByteToWideChar(CP_ACP,0,(LPCTSTR)&szMyPicture,-1,(LPWSTR)&pszMyPicture,512);

	sc = OleCreateFromFile(&clsid,(LPCOLESTR)&pszMyPicture,&IID_IUnknown,
							OLERENDER_DRAW,lpFormatEtc,m_lpClientSite,m_lpStorage,
							(void**)&m_lpObject);
	if (sc != S_OK)
	{
		goto SelectEnd;
	}
	if (m_lpObject == NULL)
	{
		goto SelectEnd;
	}
	lpUnk = (LPUNKNOWN)m_lpObject;

	lpUnk->lpVtbl->QueryInterface(lpUnk,&IID_IOleObject, (void**)&m_lpObject);
	lpUnk->lpVtbl->Release(lpUnk);
	if (m_lpObject == NULL)
	{
		goto SelectEnd;
	}
	sc = OleSetContainedObject((LPUNKNOWN)m_lpObject,TRUE);
	if (sc != S_OK)
	{
		goto SelectEnd;
	}
	ZeroMemory(&reobject,sizeof(REOBJECT));
	reobject.cbStruct = sizeof(REOBJECT);

	// Get the CLSID of the object.
	//.............................
	sc = m_lpObject->lpVtbl->GetUserClassID(m_lpObject,&clsid);

	if (sc != S_OK)
	{
		goto SelectEnd;
	}
	reobject.clsid = clsid;
	reobject.cp = REO_CP_SELECTION;
	reobject.dvaspect = DVASPECT_CONTENT;
	reobject.dwFlags = REO_RESIZABLE | REO_BELOWBASELINE;
	reobject.dwUser = 0;
	reobject.poleobj = m_lpObject;
	reobject.polesite = m_lpClientSite;
	reobject.pstg = m_lpStorage;
	sizel.cx = sizel.cy = 0;
	reobject.sizel = sizel;

	// Insert the object.
	//...................
	m_pRichEditOle->lpVtbl->InsertObject(m_pRichEditOle,&reobject);

	SelectEnd:

	if (m_lpObject)
	{
		m_lpObject->lpVtbl->Release(m_lpObject);
	}
	if (m_lpStorage)
	{
		m_lpStorage->lpVtbl->Release(m_lpStorage);
	}
	if (m_lpClientSite)
	{
		m_lpClientSite->lpVtbl->Release(m_lpClientSite);
	}
	if (bHaveOle)
	{
		m_pRichEditOle->lpVtbl->Release(m_pRichEditOle);
	}
	OleUninitialize();
}

// Load a bitmap file.
//....................
BOOL LoadMyBitmap(LPCTSTR lpBitmap)
{
	BOOL			bResult = FALSE;
	int				nLogPixelsX;
    int				nLogPixelsY;
	HDC				hRtfdc = 0;
	HDC				hDc1 = 0;
	HDC				hdcMetaFile = 0;
	HANDLE			hSmiley = 0;
	BITMAP			bm;
	int				iResult;
	BOOL			bGood;
	CHARFORMAT2		cr2;
	int				picw, pich, picwgoal, pichgoal;
	LPBYTE			lpRtfString = 0;
	int				iFamilyIndex;
	HMETAFILE		hMetaFile;
	UINT			uBytes = 0;
	LPBYTE			lpMetaBuffer = 0;
	LPBYTE			lpHexBuffer = 0;

	hRtfdc = GetDC(hCurrentRtfWnd);
	if (!hRtfdc)
	{
		goto BmEnd;
	}
	// Get the font information from the rtf control.
	//...............................................
	cr2.cbSize = sizeof(CHARFORMAT2);
	SendMessage(hCurrentRtfWnd,EM_GETCHARFORMAT,1,(LPARAM)&cr2);

	nLogPixelsX = GetDeviceCaps(hRtfdc,LOGPIXELSX);
    nLogPixelsY = GetDeviceCaps(hRtfdc,LOGPIXELSY);
	
	// Create the second compatable DC.
	//.................................
	hDc1 = CreateCompatibleDC(hRtfdc);
	if (!hDc1)
	{
		goto BmEnd;
	}
	// Load the smiley bitmap.
	//........................
	hSmiley = LoadImage(NULL,lpBitmap,IMAGE_BITMAP,0,0,LR_DEFAULTCOLOR | LR_LOADFROMFILE);
	if (hSmiley)
	{
		iResult = GetObject(hSmiley,sizeof(BITMAP),&bm);
		if (!iResult)
		{
			goto BmEnd;
		}
		SelectObject(hDc1,hSmiley);
		// Calculate the required values for the \pic entry.
		//..................................................
		picw = MyCalcs(bm.bmWidth,HMM_PER_INCH,nLogPixelsX);
		pich = MyCalcs(bm.bmHeight,HMM_PER_INCH,nLogPixelsY);
		picwgoal = MyCalcs(bm.bmWidth,TWIPS_PER_INCH,nLogPixelsX);
		pichgoal = MyCalcs(bm.bmHeight,TWIPS_PER_INCH,nLogPixelsY);

		iFamilyIndex = (cr2.bPitchAndFamily & 0xf0) >> 4;
		if (iFamilyIndex > 7)
		{
			iFamilyIndex = 0;
		}
		// Lets create the metafile.
		//..........................
		hdcMetaFile = CreateMetaFile(NULL);
		if (!hdcMetaFile)
		{
			goto BmEnd;
		}
		SetMapMode(hdcMetaFile,MM_ANISOTROPIC);
		SetWindowExtEx(hdcMetaFile,0,0,NULL);
		SetViewportExtEx(hdcMetaFile,1,1,NULL);

		// Copy the bitmap into the metafile device context.
		//..................................................
		bGood = BitBlt(hdcMetaFile,0,0,bm.bmWidth,bm.bmHeight,hDc1,0,0,SRCCOPY);
		if (!bGood)
		{
			goto BmEnd;
		}
		hMetaFile = CloseMetaFile(hdcMetaFile);
		if (!hMetaFile)
		{
			goto BmEnd;
		}
		// First get the number of bytes required.
		//........................................
		uBytes = GetMetaFileBitsEx(hMetaFile,0,NULL);
		if (!uBytes)
		{
			goto BmEnd;
		}
		lpMetaBuffer = AllocateMemory(uBytes + 16);
		if (!lpMetaBuffer)
		{
			goto BmEnd;
		}
		uBytes = GetMetaFileBitsEx(hMetaFile,uBytes,lpMetaBuffer);
		if (!uBytes)
		{
			goto BmEnd;
		}
		lpHexBuffer = AllocateMemory((uBytes * 2) + 2);
		if (!lpHexBuffer)
		{
			goto BmEnd;
		}
		// Convert the buffer to hex.
		//...........................
		ChangeToHex(uBytes,lpMetaBuffer,lpHexBuffer,FORWARD);

		// Allocate memory for the rtf string.
		//....................................
		lpRtfString = AllocateMemory((uBytes * 2) + 2048);
		if (!lpRtfString)
		{
			goto BmEnd;
		}
		StringCbPrintf((LPTSTR)lpRtfString,((uBytes * 2) + 2048),(LPCTSTR)&szRTFHeader,
					   (LPCTSTR)lpFontFamily[iFamilyIndex],
					   (LPCTSTR)&cr2.szFaceName,picw,pich,picwgoal,pichgoal);

		StringCbCatEx((LPTSTR)lpRtfString,((uBytes * 2) + 2048),(LPCTSTR)lpHexBuffer,NULL,
					   NULL,dwStringSafeFlag);
		StringCbCatEx((LPTSTR)lpRtfString,((uBytes * 2) + 2048),(LPCTSTR)&szRTFImagePost,NULL,
					   NULL,dwStringSafeFlag);

		// Stream the rtf data into our rtf control.
		//..........................................
		dwPageCount = lstrlen(lpRtfString);
		lpOutBuffer = lpRtfString;
		eStreamRecv.dwCookie = (DWORD)lpOutBuffer;
		eStreamRecv.dwError = 0;
		eStreamRecv.pfnCallback = EditStreamPageInCallback;

		SendMessage(hCurrentRtfWnd,EM_STREAMIN,(WPARAM)SF_RTF | SFF_SELECTION,
					(LPARAM)&eStreamRecv);
		if (eStreamRecv.dwError)
		{
			goto BmEnd;
		}
		SendMessage(hCurrentRtfWnd,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cr2);
		bResult = TRUE;
	}

	BmEnd:

	if (hRtfdc)
	{
		ReleaseDC(hCurrentRtfWnd,hRtfdc);
	}
	if (hDc1)
	{
		DeleteDC(hDc1);
	}
	if (hSmiley)
	{
		DeleteObject(hSmiley);
	}
	if (lpRtfString)
	{
		ZeroMemory(lpRtfString,((uBytes * 2) + 2048));
		DeallocateMemory(lpRtfString);
	}
	if (hMetaFile)
	{
		DeleteMetaFile(hMetaFile);
	}
	if (lpMetaBuffer)
	{
		ZeroMemory(lpMetaBuffer,(uBytes + 16));
		DeallocateMemory(lpMetaBuffer);
		lpMetaBuffer = 0;
	}
	if (lpHexBuffer)
	{
		ZeroMemory(lpHexBuffer,((uBytes * 2) + 2));
		DeallocateMemory(lpHexBuffer);
		lpHexBuffer = 0;
	}
	return(bResult);
}
